/*
 * Decompiled with CFR 0.152.
 */
package org.reviewboard.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TFSDiffer {
    private static TFSDiffer instance = null;
    private static Log log = LogFactory.getLog(TFSDiffer.class);
    private final Charset utf8 = Charset.forName("UTF-8");

    protected TFSDiffer() {
    }

    public static TFSDiffer getInstance() {
        if (instance == null) {
            instance = new TFSDiffer();
        }
        return instance;
    }

    public DiffResult diffPendingSets(PendingSet[] sets, VersionControlClient versionControl) {
        DiffResult result = new DiffResult();
        try (ByteArrayOutputStream diffStream = new ByteArrayOutputStream();){
            boolean foundCandidateChanges = false;
            for (PendingSet set : sets) {
                for (PendingChange change : set.getPendingChanges()) {
                    this.diffPendingChange(change, versionControl, diffStream);
                }
                PendingChange[] candidateChanges = set.getCandidatePendingChanges();
                if (candidateChanges == null || candidateChanges.length <= 0) continue;
                result.warnAboutDirty = true;
            }
            result.diff = diffStream.toByteArray();
        }
        catch (VersionControlException | IOException | DiffException e) {
            result.err = e.getMessage();
            result.success = false;
        }
        return result;
    }

    private final void diffPendingChange(PendingChange change, VersionControlClient versionControl, ByteArrayOutputStream diff) throws DiffException, IOException {
        block30: {
            File newFile;
            File oldFile;
            String serverItem = change.getServerItem();
            ChangeType changeType = change.getChangeType();
            ItemType itemType = change.getItemType();
            ChangeType availableTypes = ChangeType.combine(new ChangeType[]{ChangeType.ADD, ChangeType.BRANCH, ChangeType.DELETE, ChangeType.EDIT, ChangeType.RENAME, ChangeType.UNDELETE});
            if (itemType != ItemType.FILE || !changeType.containsAny(availableTypes)) {
                log.info("Skipping " + changeType.toUIString(false) + " of " + serverItem + " (" + itemType.toUIString() + ")");
                return;
            }
            TempStorageService tempStorage = TempStorageService.getInstance();
            boolean isBinary = change.getEncoding() == -1;
            String oldVersion = new Integer(change.getVersion()).toString();
            String oldFilename = change.getServerItem();
            String newVersion = "(pending)";
            String newFilename = oldFilename;
            if (change.isRename() || change.isBranch()) {
                oldFilename = change.getSourceServerItem();
                oldVersion = new Integer(change.getSourceVersionFrom()).toString();
            }
            if (change.isAdd() || change.isUndelete()) {
                log.info("Creating empty file to represent old version of " + serverItem);
                oldFile = tempStorage.createTempFile();
                oldFilename = "/dev/null";
            } else if (isBinary) {
                log.info("Creating empty file to represent old version of " + serverItem);
                oldFile = tempStorage.createTempFile();
            } else {
                log.info("Downloading old version of " + serverItem);
                oldFile = change.downloadBaseFileToTempLocation(versionControl, serverItem + ".old");
                log.info("Downloaded old version of " + serverItem + " to " + oldFile);
            }
            if (change.isDelete()) {
                log.info("Creating empty file to represent new version of " + serverItem);
                newFile = tempStorage.createTempFile();
                newVersion = "(deleted)";
            } else if (change.isInShelveset()) {
                log.info("Downloading new version of " + serverItem);
                newFile = change.downloadShelvedFileToTempLocation(versionControl, serverItem + ".new");
                log.info("Finished downloading new version of " + serverItem + " to " + newFile);
            } else {
                String localItem = change.getLocalItem();
                log.info("Using local item " + localItem + " as new version of " + serverItem);
                newFile = new File(localItem);
            }
            String oldLabel = oldFilename + "\t" + oldVersion;
            String newLabel = newFilename + "\t" + newVersion;
            log.info("Processing pending change " + changeType.toUIString(false) + " of " + serverItem);
            if (change.isBranch()) {
                IOUtils.write("Copied from: " + oldFilename + "\n", (OutputStream)diff, this.utf8);
            }
            if (isBinary) {
                IOUtils.write("--- " + oldLabel + "\n", (OutputStream)diff, this.utf8);
                IOUtils.write("+++ " + newLabel + "\n", (OutputStream)diff, this.utf8);
                IOUtils.write("Binary files " + oldFilename + " and " + newFilename + " differ\n", (OutputStream)diff, this.utf8);
            } else if (!oldFilename.equals(newFilename) && FileUtils.contentEquals(oldFile, newFile)) {
                IOUtils.write("--- " + oldLabel + "\n", (OutputStream)diff, this.utf8);
                IOUtils.write("+++ " + newLabel + "\n", (OutputStream)diff, this.utf8);
            } else {
                Process p = Runtime.getRuntime().exec(new String[]{"diff", "-u", "--label", oldLabel, "--label", newLabel, oldFile.getAbsolutePath(), newFile.getAbsolutePath()});
                try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                    IOUtils.copy(p.getInputStream(), (OutputStream)output);
                    String error = IOUtils.toString(p.getErrorStream(), this.utf8);
                    int retcode = p.waitFor();
                    if (retcode == 0 || retcode == 1) {
                        IOUtils.write(output.toByteArray(), (OutputStream)diff);
                        break block30;
                    }
                    String diffError = IOUtils.toString(p.getErrorStream(), this.utf8);
                    throw new DiffException("diff command failed with output:\n" + error);
                }
                catch (IOException | InterruptedException e) {
                    throw new DiffException("diff command failed: " + e.getMessage());
                }
            }
        }
    }

    protected class DiffException
    extends Exception {
        public DiffException(String message) {
            super(message);
        }
    }

    public static class DiffResult {
        public byte[] diff = null;
        public String err = null;
        public boolean warnAboutDirty = false;
        public boolean success = true;
    }
}

