/*
 * Decompiled with CFR 0.152.
 */
package org.reviewboard.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Shelveset;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reviewboard.tfs.Command;
import org.reviewboard.tfs.TFSCollection;

public class CommandParseRevision
extends Command {
    private static Log log = LogFactory.getLog(CommandParseRevision.class);

    @Override
    public String getUsage() {
        return "[revision or shelveset ...]";
    }

    @Override
    public Option[] getOptions() {
        return ArrayUtils.addAll(super.getOptions(), Option.builder().longOpt("shelveset-owner").desc("Look up the shelveset created by the given owner.").hasArg().argName("owner").build());
    }

    @Override
    public void run(CommandLine commandLine) throws ParseException {
        String[] revision = commandLine.getArgs();
        try (TFSCollection collection = this.getCollection(commandLine);){
            if (revision.length == 0) {
                WorkspaceVersionSpec version = new WorkspaceVersionSpec(collection.workspace.getWorkspace(collection));
                Changeset change = this.getChanges(collection, null, version, 1)[0];
                System.out.println(change.getChangesetID());
                System.out.println("--rb-tfs-working-copy");
                return;
            }
            if (revision.length == 1) {
                String ownerName = commandLine.hasOption("owner") ? commandLine.getOptionValue("owner") : collection.workspace.getOwnerName();
                VersionControlClient versionControl = collection.getVersionControlClient();
                Shelveset[] shelvesets = versionControl.queryShelvesets(revision[0], ownerName, null);
                if (shelvesets.length == 1) {
                    System.out.println("--rb-tfs-shelveset-base");
                    System.out.println("--rb-tfs-shelveset:" + revision[0]);
                    return;
                }
            }
            VersionSpec fromVersion = null;
            VersionSpec toVersion = null;
            if (revision.length == 1) {
                VersionSpec[] versions = VersionSpec.parseMultipleVersionsFromSpec(revision[0], null, true);
                if (versions.length == 1) {
                    toVersion = versions[0];
                } else if (versions.length == 2) {
                    fromVersion = versions[0];
                    toVersion = versions[1];
                } else assert (false) : versions;
            } else if (revision.length == 2) {
                fromVersion = VersionSpec.parseSingleVersionFromSpec(revision[0], null);
                toVersion = VersionSpec.parseSingleVersionFromSpec(revision[1], null);
            } else {
                throw new ParseException("parse-revision takes between zero and two revisions");
            }
            Object[] changes = null;
            if (fromVersion == null) {
                changes = this.getChanges(collection, fromVersion, toVersion, 2);
                ArrayUtils.reverse(changes);
            } else {
                changes = new Changeset[]{this.getChanges(collection, null, fromVersion, 1)[0], this.getChanges(collection, null, toVersion, 1)[0]};
            }
            for (Object change : changes) {
                System.out.println(((Changeset)change).getChangesetID());
            }
        }
    }

    private Changeset[] getChanges(TFSCollection collection, VersionSpec fromVersion, VersionSpec toVersion, int maxChanges) {
        return collection.getVersionControlClient().queryHistory(collection.workdir, LatestVersionSpec.INSTANCE, 0, RecursionType.FULL, null, fromVersion, toVersion, maxChanges, false, false, false, false);
    }
}

