/*
 * Decompiled with CFR 0.152.
 */
package org.reviewboard.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.exceptions.TECoreException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reviewboard.tfs.Command;
import org.reviewboard.tfs.TFSCollection;
import org.reviewboard.tfs.TFSDiffer;

public class CommandDiff
extends Command {
    private static Log log = LogFactory.getLog(CommandDiff.class);
    private CommandLine commandLine;

    @Override
    public Option[] getOptions() {
        return ArrayUtils.addAll(super.getOptions(), Option.builder((String)"h").longOpt("help").desc("Show help.").build(), Option.builder().longOpt("shelveset-owner").desc("Look up the shelveset created by the given owner.").hasArg().argName("owner").build());
    }

    @Override
    public String getUsage() {
        return "[options] revision1 revision2";
    }

    @Override
    public void run(CommandLine commandLine) throws ParseException {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new ParseException("diff command requires specifying revisions");
        }
        String base = args[0];
        String tip = args[1];
        try (TFSCollection collection = this.getCollection(commandLine);){
            TFSDiffer.DiffResult diffResult = null;
            if (tip.startsWith("--rb-tfs-shelveset:")) {
                String shelvesetName = tip.substring("--rb-tfs-shelveset:".length());
                String ownerName = commandLine.hasOption("shelveset-owner") ? commandLine.getOptionValue("shelveset-owner") : collection.workspace.getOwnerName();
                diffResult = this.getShelvesetDiff(collection, shelvesetName, ownerName);
            } else {
                diffResult = tip.equals("--rb-tfs-working-copy") ? this.getWorkingCopyDiff(collection) : this.getCommittedChangesetsDiff(collection, base, tip);
            }
            if (diffResult.diff != null) {
                IOUtils.write(diffResult.diff, (OutputStream)System.out);
            }
            if (diffResult.err != null) {
                System.err.println(diffResult.err);
            }
            if (!diffResult.success) {
                System.exit(1);
            } else if (diffResult.warnAboutDirty) {
                System.exit(2);
            }
        }
        catch (TECoreException | IOException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private TFSDiffer.DiffResult getShelvesetDiff(TFSCollection collection, String shelvesetName, String ownerName) {
        VersionControlClient versionControl = collection.getVersionControlClient();
        log.info("Querying for shelveset '" + shelvesetName + "' (" + ownerName + ")");
        PendingSet[] pendingSets = versionControl.queryShelvedChanges(shelvesetName, ownerName, null, true);
        return TFSDiffer.getInstance().diffPendingSets(pendingSets, versionControl);
    }

    private TFSDiffer.DiffResult getWorkingCopyDiff(TFSCollection collection) {
        VersionControlClient versionControl = collection.getVersionControlClient();
        WorkspaceInfo workspace = collection.workspace;
        String[] items = new String[]{collection.workdir};
        ItemSpec[] specs = ItemSpec.fromStrings(items, RecursionType.FULL);
        log.info("Doing diff of working copy");
        PendingSet[] pendingSets = versionControl.queryPendingSets(specs, true, workspace.getName(), workspace.getOwnerName(), true);
        return TFSDiffer.getInstance().diffPendingSets(pendingSets, versionControl);
    }

    private TFSDiffer.DiffResult getCommittedChangesetsDiff(TFSCollection collection, String base, String tip) {
        TFSDiffer.DiffResult result = new TFSDiffer.DiffResult();
        result.err = "Diffing between committed revisions isn't implemented yet.";
        result.success = false;
        return result;
    }
}

