/*
 * Decompiled with CFR 0.152.
 */
package org.reviewboard.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.credentials.CachedCredentials;
import com.microsoft.tfs.core.credentials.CredentialsManager;
import com.microsoft.tfs.core.credentials.CredentialsManagerFactory;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.util.ServerURIUtils;
import java.io.File;
import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reviewboard.tfs.Application;
import org.reviewboard.tfs.TFSCollection;

public abstract class Command {
    private static Log log = LogFactory.getLog(Command.class);

    public abstract String getUsage();

    public abstract void run(CommandLine var1) throws ParseException;

    public Option[] getOptions() {
        return new Option[]{Option.builder().longOpt("workdir").desc("Local workdir.").hasArg().argName("workdir").build(), Option.builder().longOpt("login").desc("TFS login information.").hasArg().argName("username@domain,password").build()};
    }

    protected final TFSCollection getCollection(CommandLine commandLine) {
        String workdir = new File(commandLine.hasOption("workdir") ? commandLine.getOptionValue("workdir") : LocalPath.getCurrentWorkingDirectory()).getAbsolutePath();
        log.info("Using working directory " + workdir);
        WorkspaceInfo workspace = Command.getLocalWorkspace(workdir);
        URI serverURI = workspace.getServerURI();
        log.info("Using TFS server " + serverURI);
        Credentials credentials = Command.findCredentials(serverURI, commandLine.getOptionValue("login"));
        return new TFSCollection(serverURI, credentials, workdir, workspace);
    }

    protected static Credentials findCredentials(URI serverURI, String login) {
        CredentialsManager credentialsManager = CredentialsManagerFactory.getCredentialsManager(DefaultPersistenceStoreProvider.INSTANCE, !Application.getBooleanEnvVar("TF_USE_KEYCHAIN", true));
        CachedCredentials cachedCredentials = credentialsManager.getCredentials(serverURI);
        if (login != null) {
            String[] parts = login.split(",", 2);
            String username = parts[0];
            String password = parts.length == 2 ? parts[1] : null;
            return new UsernamePasswordCredentials(username, password);
        }
        if (cachedCredentials != null && cachedCredentials.getUsername() != null && cachedCredentials.getUsername().length() > 0) {
            return new UsernamePasswordCredentials(cachedCredentials.getUsername(), cachedCredentials.getPassword());
        }
        if (!ServerURIUtils.isHosted(serverURI)) {
            return new DefaultNTCredentials();
        }
        return null;
    }

    protected static WorkspaceInfo getLocalWorkspace(String workdir) {
        Workstation workstation = Workstation.getCurrent(DefaultPersistenceStoreProvider.INSTANCE);
        if (workdir != null && workstation.isMapped(workdir)) {
            return workstation.getLocalWorkspaceInfo(workdir);
        }
        return null;
    }
}

