/*
 * Decompiled with CFR 0.152.
 */
package org.reviewboard.tfs;

import com.microsoft.tfs.jni.PlatformMiscUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.reviewboard.tfs.Command;
import org.reviewboard.tfs.CommandDiff;
import org.reviewboard.tfs.CommandGetCollection;
import org.reviewboard.tfs.CommandParseRevision;

public class Application {
    private static final HashMap<String, Command> commandClasses = new HashMap();

    public static void main(String[] args) throws IOException, URISyntaxException {
        Path currentJar = Paths.get(Application.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        Path nativeDir = currentJar.resolve("../lib/native").toRealPath(new LinkOption[0]);
        System.setProperty("com.microsoft.tfs.jni.native.base-directory", nativeDir.toString());
        Options options = new Options();
        options.addOption(Option.builder().longOpt("debug").desc("Enable debug output.").build());
        DefaultParser parser = new DefaultParser();
        String commandName = null;
        Command command = null;
        try {
            CommandLine commandLine = parser.parse(options, args, true);
            String[] capturedArgs = commandLine.getArgs();
            if (capturedArgs.length == 0 || capturedArgs.length == 1 && capturedArgs[0].equals("help")) {
                Application.showHelp(null, "[command] [options]", options, true);
                System.exit(0);
            }
            if ((command = commandClasses.get(commandName = capturedArgs[0])) == null) {
                System.err.println("Unknown command \"" + commandName + "\"");
                Application.showHelp(null, "[command] [options]", options, true);
                System.exit(1);
            }
            for (Option option : command.getOptions()) {
                options.addOption(option);
            }
            args = Arrays.copyOfRange(capturedArgs, 1, capturedArgs.length);
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption("debug")) {
                Logger.getRootLogger().setLevel(Level.INFO);
            }
            command.run(commandLine);
        }
        catch (ParseException e) {
            if (e.getMessage() != null) {
                System.err.println((Object)e);
            }
            Application.showHelp(commandName, command != null ? command.getUsage() : null, options, command == null);
            System.exit(1);
        }
    }

    private static void showHelp(String commandName, String args, Options options, boolean listCommands) {
        String usage = "rb-tfs";
        if (commandName != null) {
            usage = usage + " " + commandName;
        }
        if (args != null) {
            usage = usage + " " + args;
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(usage, options);
        if (listCommands) {
            System.out.println();
            System.out.println("Available commands:");
            for (String command : commandClasses.keySet()) {
                System.out.println("    " + command);
            }
        }
    }

    public static final boolean getBooleanEnvVar(String envVar, boolean defaultValue) {
        String value = PlatformMiscUtils.getInstance().getEnvironmentVariable(envVar);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return !value.equalsIgnoreCase("FALSE") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("N");
    }

    static {
        commandClasses.put("diff", new CommandDiff());
        commandClasses.put("get-collection", new CommandGetCollection());
        commandClasses.put("parse-revision", new CommandParseRevision());
    }
}

